/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.eventlog;

import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.pa.eventlog.EventLogRootNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogTree;
import filenet.vw.toolkit.utils.VWStringUtils;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class EventLogBaseNode
extends DefaultMutableTreeNode {
    private String m_name = null;
    private Icon m_icon = null;
    private boolean m_bSelected = false;
    private long m_refreshTimestamp = -1L;

    public EventLogBaseNode(String name, Icon icon) {
        this.m_name = name;
        this.m_icon = icon;
    }

    public EventLogTree getTree() {
        TreeNode root = this.getRoot();
        if (root != null && root instanceof EventLogRootNode) {
            return ((EventLogRootNode)root).getTree();
        }
        return null;
    }

    public DefaultTreeModel getModel() {
        EventLogTree tree = this.getTree();
        if (tree != null) {
            return (DefaultTreeModel)tree.getModel();
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSelected() {
        return this.m_bSelected;
    }

    public void initSelected(boolean selected) {
        this.m_bSelected = selected;
    }

    public void setSelected(boolean selected) {
        this.m_bSelected = selected;
    }

    public String getName() {
        return this.m_name;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setRefreshTimestamp(long timestamp) {
        this.m_refreshTimestamp = timestamp;
    }

    public long getRefreshTimestamp() {
        return this.m_refreshTimestamp;
    }

    public void add(EventLogBaseNode newChild) {
        try {
            int childCount = this.getChildCount();
            String newName = newChild.getName();
            if (childCount == 0) {
                this.insert(newChild, 0);
            } else {
                boolean bDone = false;
                String childName = null;
                for (int i = 0; i < childCount; ++i) {
                    childName = ((EventLogBaseNode)this.getChildAt(i)).getName();
                    if (VWStringUtils.compare(newName, childName) > 0) continue;
                    this.insert(newChild, i);
                    bDone = true;
                    break;
                }
                if (!bDone) {
                    this.insert(newChild, childCount);
                }
            }
            DefaultTreeModel model = this.getModel();
            if (model != null) {
                this.getModel().reload(this);
            }
        }
        catch (Exception ex) {
            VWTaskCore.getInstance().displayError(ex);
        }
    }
}

